// wykłady z logiki Andrzej M. Borzyszkowski
// przykład "system plików"

//Przykład 3
abstract sig FSObject { }
sig File, Dir extends FSObject { }
sig FileSystem {	
  live: set FSObject,
  root: Dir & live,					//przekrój podzbiorów
  parent: (live - root) ->one (Dir & live),
  contents: Dir -> FSObject		//jednoznaczność i tak będzie
}{
  live = root.*contents
  parent = ~contents
}
//Przykład 6
pred remove [fs, fs': FileSystem, x: FSObject] {
  x in (fs.live - fs.root)
  fs'.root = fs.root
  fs'.parent = fs.parent - x->(x.(fs.parent)) }
removeOK: check {
  all fs, fs': FileSystem, x: FSObject |
    remove[fs, fs', x] => fs'.live = fs.live - x } for 5
//
pred removeAll [fs, fs': FileSystem, x: FSObject] {
  x in (fs.live - fs.root)
  fs'.root = fs.root
  let subtree = x.*(fs.contents) |
      fs'.parent = fs.parent - subtree->(subtree.(fs.parent))
}
removeAllOK: check {
  all fs, fs': FileSystem, d: Dir |
    removeAll[fs, fs', d] => fs'.live = fs.live - d.*(fs.contents)
} for 5
removeAllSame: check {
  all fs, fs1, fs2: FileSystem, f: File |
    remove[fs, fs1, f] && removeAll[fs, fs2, f] => fs1.live = fs2.live
} for 5


