// wykłady z logiki Andrzej M. Borzyszkowski
// przykład "system plików"

//Przykład 3
abstract sig FSObject { }
sig File, Dir extends FSObject { }
sig FileSystem {	
  live: set FSObject,
  root: Dir & live,					//przekrój podzbiorów
  parent: (live - root) ->one (Dir & live),
  contents: Dir -> FSObject		//jednoznaczność i tak będzie
}{
  live = root.*contents
  parent = ~contents
}
//Przykład 4
pred move [fs, fs': FileSystem, x: FSObject, d: Dir] {
  (x + d) in fs.live
  fs'.parent = fs.parent - x->(x.(fs.parent)) + x->d
  x.(fs.parent)!=d
}  // x  oraz  d  są obiektami oryginalnego systemu plików (fs)
   // w nowym systemie plików relacja parent jest ta sama oprócz
   // odjęcia dotychczasowego przypisania dla x i dodania nowego
//run move for 2 FileSystem, 4 FSObject
moveOK: check {
  all fs, fs': FileSystem, x: FSObject, d:Dir |
    move[fs, fs', x, d] => fs'.live = fs.live
} for 5
